<?php
/*
plugin name: 子比搜索关键词编辑插件
plugin URI: https://www.zhiyanx.cn/
description: 子比搜索关键词编辑插件
author: 炙焰
author URI: https://www.zhiyanx.cn/
version: 1.0.0
*/

if (!defined('ABSPATH')) {
    die;
}

//使用Font Awesome 4
add_filter('csf_fa4', '__return_true');

// 获取插件设置链接
function zyx_search_get_admin_csf_auth_url($tab = '')
{
	$tab                = trim(strip_tags($tab));
	$tab_array          = explode("/", $tab);
	$tab_array_sanitize = array();
	foreach ($tab_array as $tab_i) {
		$tab_array_sanitize[] = sanitize_title($tab_i);
	}
	$tab_attr = esc_attr(implode("/", $tab_array_sanitize));
	$url      = add_query_arg('page', 'zyx_search', admin_url('admin.php'));
	$url      = $tab ? $url . '#tab=' . $tab_attr : $url;
	return esc_url($url);
}

//获取及设置压缩后的posts_meta
if (!function_exists('of_get_posts_meta')) 
{
    function of_get_posts_meta($name, $key, $default = false, $post_id = '')
    {
        global $post;
        $post_id  = $post_id ? $post_id : $post->ID;
        $get_mate = get_post_meta($post_id, $name, true);
        if (isset($get_mate[$key])) {
            return $get_mate[$key];
        }
        return $default;
    }
}
