<?php


// unset($search_keywords);
function update_search_keywords($keyword) {
    $options = get_option('zyx_search_keywords');
    $keywords4 = get_option('zib_other_options');
    if (!$options) {
        $options = array();
    }
    if (!isset($options['search_keywords'])) {
        $options['search_keywords'] = array();
    }
    if (array_key_exists($keyword, $keywords4['search_keywords'])) {
        unset($keywords4['search_keywords'][$keyword]);
        $result = update_option('zib_other_options', $keywords4);
        if (!$result) {
            return false;
        }
        wp_cache_delete('zib_other_options', 'options');
        return true;
    }
    return false;
}

function zyx_ajax_delete_search_date() {
    // 检查用户权限
    if (!current_user_can('administrator')) {
        echo json_encode(array('error' => 1, 'msg' => '权限不足', 'reload' => true));
        exit;
    }

    // 获取并验证POST数据
    $key = isset($_POST['key']) ? sanitize_text_field($_POST['key']) : '';
    if (empty($key)) {
        echo json_encode(array('error' => 1, 'msg' => '未提供要删除的搜索关键词', 'reload' => true));
        exit;
    }

    // 尝试删除搜索关键词
    $success = update_search_keywords($key);
    if (!$success) {
        // 注意：这里可能还需要更具体的错误信息，以便前端能够更准确地处理
        echo json_encode(array('error' => 1, 'msg' => '无法删除热门搜索关键词【' . esc_html($key) . '】', 'ys' => 'danger'));
        exit;
    }

    // 删除成功
    echo json_encode(array('error' => 0, 'msg' => '热门搜索词删除成功', 'ys' => 'success', 'reload' => true));
    exit;
}

// 假设sanitize_text_field是一个用于清理文本字段的函数，它可以根据需要被实现为WordPress的sanitize_text_field()函数或其他自定义清理函数。
// 如果这个函数不存在，你可以使用类似filter_var($input, FILTER_SANITIZE_STRING)这样的PHP内置函数来清理输入。
// 注意：esc_html()用于在输出到HTML之前转义特殊字符，防止XSS攻击。在这里，我们在错误信息中使用了它，因为错误信息可能会被显示给用户。
add_action('wp_ajax_delete_search_date', 'zyx_ajax_delete_search_date');

function zyx_delete_search_but($key) {
    $form = '<ajaxform class="ajax-form" ajax-url="' . admin_url('admin-ajax.php') . '">';
    $form .= '<a href="javascript:;" class="but jb-red ajax-submit">删除</a>';
    $form .= '<input type="hidden" ajax-name="key" value="' . $key . '">';
    $form .= '<input type="hidden" ajax-name="action" value="delete_search_date">';
    $form .= '<div class="ajax-notice"></div>';
    $form .= '</ajaxform>';
    return $form;
}

function zyx_query_search() {
    $keywords = zib_get_search_keywords();
    $html = '<div class="ajax-notice"><div style="padding: 10px;margin: 0;" class="csf-field-notice"><b><table>';
    $html .= '<tr><th>ID</th><th>热门搜索关键词</th><th>搜索次数</th><th>搜索类型</th><th>操作</th></tr>';
  
    if (!empty($keywords)) {
        $i = 1;
        foreach ($keywords as $key => $count) {
           
             $parts = explode('&type=', $key);
            $keyword = $parts[0];
            $type = isset($parts[1]) ? $parts[1] : 'all';
            $shuzas=array('search_keywords','update_theme_tasks_completed','theme_auto_aut');
             if(count($keywords)==0){
               $html .= '<tr><td colspan="5" style="color: #ff4a4a;text-align: center;">未找到对应内容，或暂无内容</td></tr>';
                break;  
             }
            if (in_array($keyword, $shuzas)) {
               
               $html .= '';
            }
            else{
            switch ($type) {
                case 'post':
                    $type_text = '文章';
                    break;
                case 'user':
                    $type_text = '用户';
                    break;
                case 'plate':
                    $type_text = '板块';
                    break;
                case 'forum':
                    $type_text = '帖子';
                    break;
                default:
                    $type_text = '全部';
            }
            $html .= '<tr><td>' . $i . '</td><td>' . esc_html($keyword) . '</td><td>' . esc_html($count) . '</td><td>' . $type_text . '</td><td>' . zyx_delete_search_but($key) . '</td></tr>';
            $i++;
            }
        }
    } else {
        $html .= '<tr><td colspan="5" style="color: #ff4a4a;text-align: center;">未找到对应内容，或暂无内容</td></tr>';
    }
    $html .= '</table></b></div></div>';
    $html .= '<style>
        table { width: 100%; border-collapse: collapse; }
        table, th, td { border: 1px solid #ddd; }
        th, td { padding: 8px; text-align: left; }
        tr:nth-child(even) { background-color: #f2f2f2; }
    </style>';
   
    return array(
        array(
            'type' => 'submessage',
            'style' => 'warning',
            'content' => $html.'
<h3 style="color:#fd4c73;"><i class="fa fa-heart fa-fw"></i> 感谢您使用子比搜索关键词编辑插件</h3>
<p>由炙焰科技推出的子比搜索关键词编辑插件！创作不易，支持正版，从我做起！</p>
<div style="margin: 10px 14px;">
    <li>官网：<a target="_blank" href="https://www.zhiyanx.cn/">https://www.zhiyanx.cn/</a></li>
    <li>官方交流群：<a target="_blank" href="https://qm.qq.com/q/1BPgJ8tbxS">立即加入</a></li>
    <li>作者联系方式：<a target="_blank" href="https://qm.qq.com/q/urmqKCOOQi">QQ 2573862370</a></li>
</div>',
));
    
    
}